definition module EdParse;

/* Clean system syntax dependend parsing */

import EdTypes, EdProgramState;

:: IdentifierPositionList = PosNil | Pos !Int !Int IdentifierPositionList;

FindIdentifiersInFile :: !Bool !(List Modulename) !String !Pathname !ProgState !Files
	-> ((!ProgState,!List Modulename,!IdentifierPositionList), !Files);

	DebugMask			:== 0;
	DontReuseUniqueNodesMask	:== 1;
	ParallelMask		:== 2;
	NoMemoryProfileMask	:== 3;
	StrictnessMask		:== 4;
	NoTimeProfileMask	:== 5;
	VerboseMask			:== 6;
	WarningsMask		:== 7;
	SystemMask			:== 8;
		
	NrOfOptions			:== 9;


/*	FindDefinitionInFile searches Clean source text (.dcl/.icl file) for an identifier.
	1st arg.	Boolean indicating whether a list of imported module names must be returned.
	2nd arg.	A list of module names to which modules names imported by this module must be
				attached.
	3rd	arg.	The Clean identifier to search for.
	4th arg.	The .dcl/.icl full path name.
	5th arg.	The program state.
	1st result	The new program state.
	2nd result	Indication whether source file could be read.
	3th result	List of imported module names.
	4th	result	Line number of definition of the identifier.
	5th result	Character number of definition of the identifier. 
*/
FindDefinitionInFile :: !Bool !(List Modulename) !String !Pathname !ProgState !Files -> ((!ProgState, !List Modulename,!IdentifierPositionList), !Files);

/*	Returns the dependencies listed in an .abc file.
	1st arg.	The full .abc path name.
	2nd arg.	
	1st result	Indication whether .abc file could be read.
	2nd result	The list of dependent modules.
	3rd result	The list of object files needed for linking
	4th result	The list of libraries needed for linking
*/
// MW P: added Lists for LinkObjFileNames and LinkLibraryNames
ParseABCDependencies :: !Pathname !Files -> (!(!Bool,!List Modulename,!List LinkObjFileName,!List LinkLibraryName),!Files);

/*	Returns further info from an .abc file:
	1st arg.	full path name of the .abc file.
	2nd	arg.	program state.
	1st result	the new program state.
	2nd result	is this module a system file?
	3rd result	does this .abc file contain sequential stack info?
	4th result	version number of compiler which generated the .abc file (-1 if .abc file could not
				be read). 
	5th result	compiler options this .abc file was generated with (except 'Show Type Info').
*/
GetABCCompiledInfo :: !Pathname  !Files -> (!Files, !Bool, !Bool, !Int, !ABCOptions);

/*	Returns True when 1st arg. is a valid Clean identifier. */
CleanModId:: !String -> Bool;

/*	Returns True when 1st arg. is a type listed by the Clean compiler. */
IsTypeSpec :: !String -> Bool;

IsImportError :: !String -> (!Bool,!Modulename);

/*	Parses an error message given by the Clean compiler and returns the name of the module and the
	line number mentioned in the message.
*/
ParseErrorMsg :: !String -> (!Modulename, !Int);

/*	Makes a message that an identifier has been found by a 'find definition/implementation' and
	which can be parsed by 'ParseErrorMsg'.
	1st arg.	Indication whether this is a definition.
	2nd arg.	The module name the identifier was found in.
	3rd arg.	The line number where the definition/implementation was found.
	4th arg.	The identifier that was found.
	result		A Message which can be parsed by 'ParseErrorMsg'.
*/
MakeFoundMsg :: !SearchKind !String !Int !String -> String;

OpenTextFile :: !Pathname !Files -> (!Files, !Bool, !*File);
CloseTextFile :: !*File !Files -> Files;
